// Background script for CB Vulgarities extension
console.log('CB Vulgarities Extension: Background script loaded');

// Internal state
let appState = {
  currentMode: 'pre-show',
  isRunning: false
};

// Initialize state from storage
chrome.storage.local.get(['currentMode', 'isRunning'], (result) => {
  if (result.currentMode) appState.currentMode = result.currentMode;
  if (result.isRunning !== undefined) appState.isRunning = result.isRunning;
  console.log('CB Vulgarities Extension: Initial state loaded', appState);
});

// Listen for extension installation/update
chrome.runtime.onInstalled.addListener((details) => {
  console.log('CB Vulgarities Extension: Installed/Updated', details);

  if (details.reason === 'install') {
    console.log('CB Vulgarities Extension: First time installation');
    // Set default state on first install
    chrome.storage.local.set({
      currentMode: 'pre-show',
      isRunning: false
    }, () => {
      console.log('CB Vulgarities Extension: Default state initialized');
    });
  } else if (details.reason === 'update') {
    console.log('CB Vulgarities Extension: Updated to version', chrome.runtime.getManifest().version);
  }
});

// Listen for messages from content scripts
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  console.log('CB Vulgarities Extension: Message received', request);

  if (request.action === 'stateChanged') {
    // Update internal state
    appState = { ...appState, ...request.state };
    console.log('CB Vulgarities Extension: State updated', appState);

    // Broadcast state change to all tabs if needed
    chrome.tabs.query({}, (tabs) => {
      tabs.forEach(tab => {
        if (tab.id !== sender.tab?.id) {
          chrome.tabs.sendMessage(tab.id, {
            action: 'syncState',
            state: appState
          }).catch(() => {
            // Ignore errors for tabs that don't have our content script
          });
        }
      });
    });

    sendResponse({ status: 'success', state: appState });
  } else if (request.action === 'getState') {
    // Return current state
    sendResponse({ status: 'success', state: appState });
  } else {
    sendResponse({ status: 'received' });
  }

  return true;
});

// Listen for storage changes
chrome.storage.onChanged.addListener((changes, areaName) => {
  if (areaName === 'local') {
    console.log('CB Vulgarities Extension: Storage changed', changes);
    if (changes.currentMode) appState.currentMode = changes.currentMode.newValue;
    if (changes.isRunning !== undefined) appState.isRunning = changes.isRunning.newValue;
  }
});

console.log('CB Vulgarities Extension: Background script initialization complete');
