// Popup script for CB Vulgarities extension
console.log('CB Vulgarities Extension: Popup loaded');

document.addEventListener('DOMContentLoaded', () => {
  console.log('CB Vulgarities Extension: Popup DOM loaded');

  const statusEl = document.getElementById('status');
  const currentModeEl = document.getElementById('current-mode');
  const runningStatusEl = document.getElementById('running-status');
  const manifest = chrome.runtime.getManifest();

  statusEl.textContent = `✓ Extension v${manifest.version} loaded successfully`;

  // Load current state from storage
  chrome.storage.local.get(['currentMode', 'isRunning'], (result) => {
    const mode = result.currentMode || 'pre-show';
    const isRunning = result.isRunning || false;

    currentModeEl.textContent = mode;
    runningStatusEl.textContent = isRunning ? 'Running' : 'Stopped';
    runningStatusEl.style.color = isRunning ? 'rgba(100, 255, 150, 0.9)' : 'rgba(255, 255, 255, 0.7)';

    console.log('CB Vulgarities Extension: Current state', { mode, isRunning });
  });

  // Listen for state changes
  chrome.storage.onChanged.addListener((changes, areaName) => {
    if (areaName === 'local') {
      if (changes.currentMode) {
        currentModeEl.textContent = changes.currentMode.newValue;
      }
      if (changes.isRunning !== undefined) {
        const isRunning = changes.isRunning.newValue;
        runningStatusEl.textContent = isRunning ? 'Running' : 'Stopped';
        runningStatusEl.style.color = isRunning ? 'rgba(100, 255, 150, 0.9)' : 'rgba(255, 255, 255, 0.7)';
      }
    }
  });

  console.log('CB Vulgarities Extension: Popup initialized', {
    version: manifest.version,
    name: manifest.name
  });
});
